Attribute VB_Name = "modSinglePayslip"
Option Explicit

Const EMP_SHEET As String = "EMPLOYEES"
Const PAY_SHEET As String = "PAYROLL"
Const SLIP_SHEET As String = "PAYSLIP"

'==============================
'   GENERATE SINGLE PAYSLIP
'==============================
Sub GenerateSinglePayslip(empID As String, payMonthText As String)

    Dim empWS As Worksheet, payWS As Worksheet, slipWS As Worksheet
    Dim lastRow As Long, r As Long
    Dim found As Boolean
    Dim payMonth As Date, rowMonth As Date
    Dim v As Variant
    Dim savePath As String, fileName As String, fullPath As String
    Dim safeMonth As String
    
    If empID = "" Or payMonthText = "" Then
        MsgBox "Provide Employee ID and Month!", vbExclamation
        Exit Sub
    End If
    
    '-----------------------------------
    ' SAFE user month conversion
    '-----------------------------------
    On Error Resume Next
    
    If IsDate(payMonthText) Then
        payMonth = DateSerial(Year(CDate(payMonthText)), Month(CDate(payMonthText)), 1)
    Else
        payMonth = DateValue("01-" & payMonthText)
    End If
    
    If Err.Number <> 0 Then
        MsgBox "Invalid Month Format. Try: Jan-2025", vbCritical
        Exit Sub
    End If
    On Error GoTo 0
    
    Set empWS = Sheets(EMP_SHEET)
    Set payWS = Sheets(PAY_SHEET)
    Set slipWS = Sheets(SLIP_SHEET)
    
    lastRow = payWS.Cells(payWS.Rows.Count, "A").End(xlUp).Row
    found = False
    
    For r = 2 To lastRow
        
        v = payWS.Cells(r, 2).Value
        
        If v <> "" Then
        
            '-----------------------------------
            ' SAFE payroll month conversion
            '-----------------------------------
            If IsDate(v) Then
                rowMonth = DateSerial(Year(v), Month(v), 1)
            Else
                rowMonth = DateValue("01-" & v)
            End If
            
            '-----------------------------------
            ' MATCH employee + month
            '-----------------------------------
            If Month(rowMonth) = Month(payMonth) And _
               Year(rowMonth) = Year(payMonth) And _
               payWS.Cells(r, 3).Value = empID Then
               
               found = True
               
               '=====================================
               ' Fill PAYSLIP SHEET
               '=====================================
               slipWS.Range("C4").Value = GetEmployeeName(empID)
               slipWS.Range("C5").Value = empID
               slipWS.Range("E4").Value = GetDepartment(empID)
               slipWS.Range("E5").Value = payWS.Cells(r, 2).Value
                
               slipWS.Range("D9").Value = payWS.Cells(r, 4).Value
               slipWS.Range("D11").Value = payWS.Cells(r, 5).Value
               slipWS.Range("D13").Value = payWS.Cells(r, 6).Value
               slipWS.Range("D15").Value = payWS.Cells(r, 9).Value
               slipWS.Range("D17").Value = payWS.Cells(r, 7).Value
               slipWS.Range("D19").Value = payWS.Cells(r, 8).Value
               slipWS.Range("D21").Value = payWS.Cells(r, 10).Value
                
               slipWS.Range("D24").Value = payWS.Cells(r, 11).Value
               slipWS.Range("D26").Value = payWS.Cells(r, 13).Value
               slipWS.Range("D28").Value = "HR / Accounts Officer"
               
               '=====================================
               ' EXPORT SAFE PDF
               '=====================================
               savePath = ThisWorkbook.path & "\Payslips"
               If Dir(savePath, vbDirectory) = "" Then MkDir savePath
               
               'Safe month text
               safeMonth = payWS.Cells(r, 2).Text
               
               fileName = empID & "_" & safeMonth & "_Payslip.pdf"
               fullPath = savePath & "\" & fileName
               
               If Dir(fullPath) <> "" Then Kill fullPath
               
               slipWS.ExportAsFixedFormat _
                    Type:=xlTypePDF, _
                    fileName:=fullPath, _
                    Quality:=xlQualityStandard, _
                    IncludeDocProperties:=True, _
                    IgnorePrintAreas:=False, _
                    OpenAfterPublish:=False
               
               Exit For
            End If
        End If
    Next r
    
    If found Then
        MsgBox "Payslip Generated & Saved Successfully!", vbInformation
    Else
        MsgBox "No payroll record found for " & empID & _
        " in " & payMonthText, vbExclamation
    End If
    
End Sub





'=============================================
'  HELPER FUNCTIONS TO FETCH EMPLOYEE DATA
'=============================================
Private Function GetEmployeeName(empID As String) As String
    Dim ws As Worksheet
    Dim r As Long, lastRow As Long
    
    Set ws = Sheets(EMP_SHEET)
    lastRow = ws.Cells(ws.Rows.Count, "A").End(xlUp).Row
    
    For r = 2 To lastRow
        If ws.Cells(r, 1).Value = empID Then
            GetEmployeeName = ws.Cells(r, 2).Value
            Exit Function
        End If
    Next r
    
    GetEmployeeName = ""
End Function


Private Function GetDepartment(empID As String) As String
    Dim ws As Worksheet
    Dim r As Long, lastRow As Long
    
    Set ws = Sheets(EMP_SHEET)
    lastRow = ws.Cells(ws.Rows.Count, "A").End(xlUp).Row
    
    For r = 2 To lastRow
        If ws.Cells(r, 1).Value = empID Then
            GetDepartment = ws.Cells(r, 4).Value
            Exit Function
        End If
    Next r
    
    GetDepartment = ""
End Function


